#!/usr/bin/env python
"""
Odbicia z dwikiem
Test w Raspberry Pi
"""
import time                     # Na potrzeby dodawania opnie
import os, pygame, sys

pygame.init()                   # Inicjowanie interfejsu graficznego
pygame.mixer.quit()
pygame.mixer.init(frequency=22050, size=-16, channels=2, buffer=512)
bounceSound = pygame.mixer.Sound("sounds/bounce.ogg")
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Odbicia, wersja 2")
screenWidth = 400
screenHeight =400
screen = pygame.display.set_mode([screenWidth,screenHeight],0,32)
background = pygame.Surface((screenWidth,screenHeight))

# Definiowanie kolorw interfejsu graficznego
cBackground =(255,255,255)
cBlock = (0,0,0)
background.fill(cBackground) # Okrelanie koloru ta
box = [screenWidth-80,screenHeight-80]
delta = [5,10]
hw = screenWidth / 2
hh = screenHeight /2
position = [hw,hh] # Pozycja piki
limit = [0, 0, 0, 0] # Granice cian
ballRad = 8 # Wielko piki

def main():
   global position
   updateBox(0,0) # Ustawianie granic cian
   screen.blit(background,[0,0])
   while True :
            checkForEvent()
            time.sleep(0.05)
            drawScreen(position)
            position = moveBall(position)
                                    
def moveBall(p):
    global delta
    p[0] += delta[0]
    p[1] += delta[1]
    if p[0] <= limit[0] :
       bounceSound.play()
       delta[0] = -delta[0]
       p[0] = limit[0]
    if p[0] >= limit[1] :
       bounceSound.play()
       delta[0] = -delta[0]
       p[0] = limit[1]
    if p[1] <= limit[2] :
       bounceSound.play()
       delta[1] = - delta[1]
       p[1] = limit[2]
    if p[1] >= limit[3] :
       bounceSound.play()
       delta[1] = - delta[1] 
       p[1] = limit[3]
    return p
             
def drawScreen(p) : # Rysowanie na ekranie
    screen.blit(background,[0,0]) # Ustawianie koloru ta
    pygame.draw.rect(screen,(255,0,0), (hw - (box[0]/2),hh - (box[1]/2),box[0],box[1]), 2)
    pygame.draw.circle(screen,cBlock, (p[0], p[1]),ballRad, 2)
    pygame.display.update()

def updateBox(d,amount):
    global box, limit
    box[d] += amount    
    limit[0] = hw - (box[0]/2) +ballRad # Lewa granica
    limit[1] = hw + (box[0]/2) -ballRad # Prawa granica
    limit[2] = hh - (box[1]/2) + ballRad # Grna granica
    limit[3] = (hh + (box[1]/2))-ballRad # Dolna granica
         
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu - prosz czeka")
    pygame.quit() # Usuwanie obiektu pygame
    sys.exit()
    
def checkForEvent(): # Sprawdzanie, czy naley zamkn program
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    if event.type == pygame.KEYDOWN :            
       if event.key == pygame.K_ESCAPE :
           terminate()
       if event.key == pygame.K_DOWN : # Powikszanie lub zmniejszanie okna
            updateBox(1,-2)
       if event.key == pygame.K_UP :
            updateBox(1,2)
       if event.key == pygame.K_LEFT :
            updateBox(0,-2)
       if event.key == pygame.K_RIGHT :
            updateBox(0,2)
       
            
if __name__ == '__main__':
    main()   
